﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;

namespace Inet.Viewer.WinForms
{
    /// <summary>
    /// Represents a composite UI component which consists of progress bar and a stop button.
    /// </summary>
    [ToolboxItem(false)] 
    public partial class ProgressControl : UserControl
    {
        /// <summary>
        /// EventHandler which is called when the user clicks on the stop button.
        /// </summary>
        public event EventHandler StopClicked;

        private ProgressMode progressMode;

        /// <summary>
        /// Creates the control.
        /// </summary>
        public ProgressControl()
        {
            InitializeComponent();
            progressBar.Style = ProgressBarStyle.Marquee;
            progressBar.MarqueeAnimationSpeed = 30;
        }

        /// <summary>
        /// Name of the progress. This name is shown as tooltip.
        /// </summary>
        public string ProgressName
        {
            set
            {
                toolTip1.SetToolTip(progressBar, value);
                progressBar.Text = value;
                toolTip1.SetToolTip(stopButton, "Stop " + value);
            }
        }

        /// <summary>
        /// Callback which is called when the users clicks on the stop button. The
        /// event is forwarded to StopClicked listeners
        /// </summary>
        /// <param name="sender">the sender</param>
        /// <param name="e">the argeuments</param>
        private void OnStopClick(object sender, EventArgs e)
        {
            if (this.StopClicked != null)
            {
                StopClicked(this, new EventArgs());
            }
        }

        /// <summary>
        /// Mode of this progress. If the mode is continuous a marquee animation is shown in the progress bar. 
        /// </summary>
        public ProgressMode ProgressMode
        {
            set
            {
                if (progressMode != value)
                {
                    if (value == ProgressMode.Continuous)
                    {
                        progressBar.Style = ProgressBarStyle.Marquee;
                    }
                    else
                    {
                        progressBar.Style = ProgressBarStyle.Blocks;
                    }
                    progressMode = value;
                }
            }
        }

        /// <summary>
        /// Value of the progress bar, in percents.
        /// </summary>
        public int ProgressValue
        {
            set
            {
               progressBar.Value = value;
            }
        }
    }
}
